#version 460

const float PI=3.1415926535;
const float TWO_PI=6.2831855;


//stuff we need for the resizing functions
uniform vec2 processingDim;
uniform float processingAspectRatio;
uniform vec2 input1Dim;
uniform float input1AspectRatio;

uniform float input1Scaler;
uniform vec2 input1Crib;


uniform sampler2DRect input1Tex;

uniform float width;
uniform float height;
uniform float time;

in vec2 texCoordVarying;

out vec4 outputColor;

//color space conversions
vec3 rgb2hsb(vec3 c)
{
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsb2rgb(vec3 c)
{
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

void main()
{
    //so what we need to do here is apply some transformations to input1Coords to ensure that we get the video
    //and then turn it into a function
    //it might be good too to convert coords into 0-1 ranges too?  maybe just do a test on this
    
    //first lets assume that we have our input is 640x480 and the output is 1280x720
	vec2 input1Coords=texCoordVarying;
    // float xRatio=input1Dim.x/processingDim.x;
    
    input1Coords+=input1Crib;
    input1Coords*=input1Scaler;
    


    vec4 input1Color=texture(input1Tex,input1Coords);
    /*
    float waaave=texture(input1Tex, texCoordVarying).g;
    float wave1=width*.375+width*.25*sin(texCoordVarying.y/height*TWO_PI+time+sin(time*3+texCoordVarying.y/height*TWO_PI));
    float wave2=width*.625+width*.25*sin(texCoordVarying.y/height*TWO_PI+time+sin(time*3+texCoordVarying.y/height*TWO_PI));

    if(texCoordVarying.x>wave1 && texCoordVarying.x<wave2){
        waaave=1.0;
    }
	*/


   // vec4 input1Color = vec4(texCoordVarying.x/width,0,texCoordVarying.y/height,1.0);
	//input1Color=vec4(1.0,0.0,1.0,1.0);
	
	//outputColor=vec4(waaave);
    outputColor=input1Color;
}
