OF_GLSL_SHADER_HEADER
//#version 320

const float PI=3.1415926535;
const float TWO_PI=6.2831855;


//stuff we need for the resizing functions
uniform vec2 processingDim;
uniform float processingAspectRatio;
uniform vec2 input1Dim;
uniform float input1AspectRatio;

uniform float input1Scaler;
uniform vec2 input1Crib;

uniform sampler2DRect input1Tex;

uniform sampler2DRect pastFramesTex;
uniform sampler2DRect temporalFilterTex;

uniform float width;
uniform float height;
uniform float time;

uniform int lumakeyMode;
//main parameters
uniform float lumakey;
uniform float mixAmnt;
uniform float hue;
uniform float sat;
uniform float bright;
//uniform vec3 hsbX;
uniform float temporalFilterMix;
uniform float temporalFilterQ;
uniform float xDisplace;
uniform float yDisplace;
uniform float zDisplace;
//uniform vec3 xyzDisplace;
uniform float rotate;
uniform float hueXMod;
uniform float hueXOffset;
uniform float hueXLfo;

uniform int hMirror;
uniform int vMirror;
uniform int briInvert;
uniform int satInvert;
uniform int hueInvert;

uniform int geoOverflowMode;

//videoactive parameters
uniform float vlumakey;
uniform float vmixAmnt;
uniform vec3 vhsbX;
uniform float vtemporalFilterMix;
uniform float vtemporalFilterQ;
uniform vec3 vxyzDisplace;
uniform float vrotate;
uniform float vhueXMod;
uniform float vhueXOffset;
uniform float vhueXLfo;

in vec2 texCoordVarying;

out vec4 outputColor;

//color space conversions
vec3 rgb2hsb(vec3 c)
{
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsb2rgb(vec3 c)
{
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

vec2 rotateCoords(vec2 inCoords, float theta){
    vec2 rotatedCoords=vec2(0);
	rotatedCoords.x = inCoords.x*cos(theta)-inCoords.y*sin(theta);
	rotatedCoords.y = inCoords.x*sin(theta)+inCoords.y*cos(theta);
	return rotatedCoords;
}
float mirror(float a){
	if(a>0.){return a;}
	if(a<0.){return -(1.+a);}
}
vec2 mirrorCoords(vec2 inCoord, vec2 inDim){
	float widthLess=inDim.x-1.0;
	float heightLess=inDim.y-1.0;
    inCoord.x=(widthLess)-mirror(mod(inCoord.x,2.0*widthLess)-widthLess);
    inCoord.y=(heightLess)-mirror(mod(inCoord.y,2.0*heightLess)-heightLess);
    return inCoord;
}
vec4 simpleBlur(sampler2DRect inTex,vec2 inCoords){//unsure if useful
    float mN=.5;//magic number!!
    vec4 blurredColor=.2*(texture(inTex, inCoords) +
                        texture(inTex,inCoords+vec2(mN,-mN)) +
                        texture(inTex,inCoords+vec2(mN,mN)) +
                        texture(inTex,inCoords+vec2(-mN,mN)) +
                        texture(inTex,inCoords+vec2(-mN,-mN)) );

    return blurredColor;
}

void main()
{
    //so what we need to do here is apply some transformations to input1Coords to ensure that we get the video
    //and then turn it into a function
    //it might be good too to convert coords into 0-1 ranges too?  maybe just do a test on this
    
    //first lets assume that we have our input is 640x480 and the output is 1280x720
	vec2 input1Coords=texCoordVarying;
    // float xRatio=input1Dim.x/processingDim.x;
    
    input1Coords+=input1Crib;
    input1Coords*=input1Scaler;
    
    vec4 input1Color=texture(input1Tex,input1Coords);
    vec4 input1ColorKeyMask=simpleBlur(input1Tex,input1Coords);//dunno if this makes any flipping difference
    float input1Bright = rgb2hsb(input1Color.rgb).z;
    /*
    float waaave=texture(input1Tex, texCoordVarying).g;
    float wave1=width*.375+width*.25*sin(texCoordVarying.y/height*TWO_PI+time+sin(time*3+texCoordVarying.y/height*TWO_PI));
    float wave2=width*.625+width*.25*sin(texCoordVarying.y/height*TWO_PI+time+sin(time*3+texCoordVarying.y/height*TWO_PI));

    if(texCoordVarying.x>wave1 && texCoordVarying.x<wave2){
        waaave=1.0;
    }
	*/

    vec2 pastFramesCoords=texCoordVarying;
    //offset coords
    pastFramesCoords-=.5*processingDim;
    //mirrors
    if(hMirror==1){
        //mix(pastFramesCoords.x,-1.0*pastFramesCoords.x, step(0.0, pastFramesCoords.x) );
        //supposedly the above should do the same thing as below, but it doesn't so far.
        if(pastFramesCoords.x>0.){
            pastFramesCoords.x*=-1.0;
        }
    }
    if(vMirror==1){
        //mix(pastFramesCoords.x,-1.0*pastFramesCoords.x, step(0.0, pastFramesCoords.x) );
        //supposedly the above should do the same thing as below, but it doesn't so far.
        if(pastFramesCoords.y>0.){
            pastFramesCoords.y*=-1.0;
        }
    }
    pastFramesCoords*=(zDisplace + input1Bright*vxyzDisplace.z);
    //mirrors
    pastFramesCoords+=vec2(xDisplace, yDisplace) + input1Bright*vxyzDisplace.xy;
    pastFramesCoords=rotateCoords(pastFramesCoords,rotate + input1Bright*vrotate);
    pastFramesCoords+=.5*processingDim;
    //toroid/wrap
    if(geoOverflowMode==1){
        pastFramesCoords=mod(pastFramesCoords,processingDim);
    }
    //mirror
    if(geoOverflowMode==2){
        pastFramesCoords=mirrorCoords(pastFramesCoords,processingDim);
    }
    vec4 pastFramesColor=texture(pastFramesTex,pastFramesCoords);
    //clamp
    if(geoOverflowMode==0){//another place to try mix/step if i figure it out)
        if(pastFramesCoords.x>processingDim.x || pastFramesCoords.x<0.){
            pastFramesColor=vec4(0);
        }
        if(pastFramesCoords.y>processingDim.y || pastFramesCoords.y<0.){
            pastFramesColor=vec4(0);
        }
    }
    vec3 pastFramesColorHsb=rgb2hsb(pastFramesColor.rgb);
   // pastFramesColorHsb.x=fract(pastFramesColorHsb.x*hsbX.x);//attenuate
	pastFramesColorHsb.x=fract(pastFramesColorHsb.x*hue);//attenuate
    pastFramesColorHsb.x*=(1.0+vhsbX.x*input1Bright);//WHAT THE FUNK
    pastFramesColorHsb.yz=clamp(pastFramesColorHsb.yz*(vec2(sat, bright))*(1.0+input1Bright*vhsbX.yz),0.0,1.0);//attenuate
    //huexMod stuffs
    pastFramesColorHsb.x+=fract((hueXLfo + vhueXLfo*input1Bright)*abs(sin(pastFramesColorHsb.x/PI)));//somethings up here
    pastFramesColorHsb.x=fract( mod( pastFramesColorHsb.x +hueXOffset + vhueXOffset*input1Bright ,hueXMod+vhueXMod*input1Bright ));//+hueXOffset + vhueXOffset*input1Bright );
    
    if(briInvert==1){pastFramesColorHsb.z=1.0-pastFramesColorHsb.z;}
    if(satInvert==1){pastFramesColorHsb.y=1.0-pastFramesColorHsb.y;}
    if(hueInvert==1){pastFramesColorHsb.x=1.0-pastFramesColorHsb.x;}//fract(abs(1.0-pastFramesColorHsb.x));}//test the fract abs thing again...
    pastFramesColor.rgb=hsb2rgb(pastFramesColorHsb);

    

    vec4 finalOutputColor=vec4(0);

    finalOutputColor=mix(input1Color,pastFramesColor,mixAmnt + input1Bright*vmixAmnt);
    //lumakey
    if(lumakeyMode==0){
        if ((input1Bright <= (lumakey + input1Bright*vlumakey) && (lumakey>0.0) )){
            finalOutputColor=pastFramesColor;
        }
    }
    if(lumakeyMode==1){
        if (input1Bright > (lumakey + input1Bright*vlumakey)){
            finalOutputColor=pastFramesColor;
        }
    }
    vec4 temporalFilterColor=texture(temporalFilterTex,texCoordVarying);
    vec3 temporalFilterColorHsb= rgb2hsb(vec3(temporalFilterColor.rgb));
	temporalFilterColorHsb.z=clamp(temporalFilterColorHsb.z*(1.0+.5*(temporalFilterQ + input1Bright*vtemporalFilterQ)),0.0,1.0);
	temporalFilterColorHsb.y=clamp(temporalFilterColorHsb.y*(1.0+.25*(temporalFilterQ+ input1Bright*vtemporalFilterQ)),0.0,1.0);
	temporalFilterColor.rgb=hsb2rgb(temporalFilterColorHsb);
    //hold off on sharpen for a moment

    finalOutputColor = mix(finalOutputColor,temporalFilterColor,temporalFilterMix + input1Bright*vtemporalFilterMix);
    outputColor=finalOutputColor;
}
