OF_GLSL_SHADER_HEADER



//stuff we need for the resizing functions
uniform sampler2DRect tex0;

in vec2 texCoordVarying;

uniform float sharpenAmount;
uniform float vsharpenAmount;

out vec4 outputColor;

//color space conversions
vec3 rgb2hsb(vec3 c)
{
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}
vec3 hsb2rgb(vec3 c)
{
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}
vec4 simpleBlur(sampler2DRect inTex,vec2 inCoords){//unsure if useful
    float mN=.5;//magic number!!
    vec4 blurredColor=.2*(texture(inTex, inCoords) +
                        texture(inTex,inCoords+vec2(mN,-mN)) +
                        texture(inTex,inCoords+vec2(mN,mN)) +
                        texture(inTex,inCoords+vec2(-mN,mN)) +
                        texture(inTex,inCoords+vec2(-mN,-mN)) );

    return blurredColor;
}

void main()
{

 
    vec4 inputColor=texture(tex0,texCoordVarying);
    vec3 inputColorHsb=rgb2hsb(inputColor.rgb);
    float inputColorBright=inputColorHsb.z;

    //float inputBright = inputColorHsb.z;
    
    float X=1.9;
    float Y=1.9;
    float sharpenBright=rgb2hsb( texture(tex0,texCoordVarying+vec2(X,Y)).rgb ).z +
                        rgb2hsb( texture(tex0,texCoordVarying+vec2(-X,Y)).rgb ).z +
                        rgb2hsb( texture(tex0,texCoordVarying+vec2(-X,-Y)).rgb ).z +
                        rgb2hsb( texture(tex0,texCoordVarying+vec2(X,-Y)).rgb ).z;
    sharpenBright=sharpenBright*.25;

   

    inputColorHsb.z-=(sharpenAmount + inputColorBright*vsharpenAmount)*sharpenBright;

    if(sharpenAmount>0){
        inputColorHsb.z*=1.0+.45*(sharpenAmount+ inputColorBright*vsharpenAmount);
        inputColorHsb.y*=1.0+.25*(sharpenAmount+ inputColorBright*vsharpenAmount);
    }


    //convert back to rgb
    inputColor.rgb=hsb2rgb( inputColorHsb );

    //inputColor.rgb=1.0-inputColor.rgb;//just for testing
    
    outputColor=inputColor;

}
