OF_GLSL_SHADER_HEADER

const float PI=3.1415926535;
const float TWO_PI=6.2831855;


uniform sampler2DRect block2InputTex;
uniform sampler2DRect tex0; //fb2 for now
uniform sampler2DRect fb2TemporalFilter;

//probably deleting all of these
uniform vec2 processingDim;

uniform vec2 block2InputDim;
uniform float block2InputScaler;
uniform vec2 block2InputCrib;

//keep
uniform vec2 block2InputXYDisplace;
uniform float block2InputZDisplace;
uniform float block2InputRotate;
uniform vec3 block2InputHSBAttenuate;
uniform float block2InputPosterize;
uniform float block2InputPosterizeInvert;
uniform int block2InputPosterizeSwitch;
uniform float block2InputKaleidoscopeAmount;
uniform float block2InputKaleidoscopeSlice;
uniform float block2InputBlurAmount;
uniform float block2InputBlurRadius;
uniform float block2InputSharpenAmount;
uniform float block2InputSharpenRadius;
uniform float block2InputFiltersBoost;	

uniform int block2InputHMirror;
uniform int block2InputVMirror;
uniform int block2InputHFlip;
uniform int block2InputVFlip;
uniform int block2InputHueInvert;
uniform int block2InputSaturationInvert;
uniform int block2InputBrightInvert;
uniform int block2InputRGBInvert;
uniform int block2InputGeoOverflow;
uniform int block2InputSolarize;

uniform float fb2MixAmount;
uniform vec3 fb2KeyValue;
uniform float fb2KeyThreshold;
uniform float fb2KeySoft;	
uniform int fb2MixType;
uniform int fb2MixOverflow;
uniform int fb2KeyOrder;

uniform vec2 fb2XYDisplace;
uniform float fb2ZDisplace;
uniform float fb2Rotate;
uniform vec4 fb2ShearMatrix;
uniform float fb2KaleidoscopeAmount;
uniform float fb2KaleidoscopeSlice;
uniform int fb2HMirror;
uniform int fb2VMirror;
uniform int fb2HFlip;
uniform int fb2VFlip;

uniform int	fb2RotateMode;
uniform	int fb2GeoOverflow;

uniform vec3 fb2HSBOffset;
uniform vec3 fb2HSBAttenuate;
uniform vec3 fb2HSBPowmap;
uniform float fb2HueShaper;
	
uniform float fb2Posterize;
uniform float fb2PosterizeInvert;
uniform int fb2PosterizeSwitch;
uniform int fb2HueInvert;
uniform int fb2SaturationInvert;
uniform int fb2BrightInvert;

//fb2 filters 
uniform	float fb2BlurAmount;
uniform	float fb2BlurRadius;
uniform	float fb2SharpenAmount;
uniform	float fb2SharpenRadius;
uniform	float fb2TemporalFilter1Amount;
uniform	float fb2TemporalFilter1Resonance;
uniform	float fb2TemporalFilter2Amount;
uniform	float fb2TemporalFilter2Resonance;
uniform float fb2FiltersBoost;	

in vec2 texCoordVarying;

out vec4 outputColor;

//color space conversions
vec3 rgb2hsb(vec3 c)
{
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsb2rgb(vec3 c)
{
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

float hueShaper(float inHue,float shaper){
	inHue=fract(abs(inHue+shaper*sin(inHue*0.3184713) ));
	return inHue;
}

vec3 colorQuantize(vec3 inColor, float amount, float amountInvert){
	
	inColor=inColor*amount;
	inColor=ceil(inColor);
	inColor=inColor*amountInvert;

	return inColor;
}

vec4 blurAndSharpen(sampler2DRect blurAndSharpenTex,vec2 coord, float sharpenAmount, float sharpenRadius, float sharpenBoost,float blurRadius,float blurAmount){
	vec4 originalColor=texture(blurAndSharpenTex,coord);
	//blur
	vec4 colorBlur=texture(blurAndSharpenTex,coord+vec2(blurRadius,blurRadius))
    + texture(blurAndSharpenTex,coord+vec2(0,blurRadius))
    + texture(blurAndSharpenTex,coord+vec2(-blurRadius,blurRadius))
    +texture(blurAndSharpenTex,coord+vec2(-blurRadius,0.0))
    +texture(blurAndSharpenTex,coord+vec2(-blurRadius,-blurRadius))
    +texture(blurAndSharpenTex,coord+vec2(0.0,-blurRadius))
    +texture(blurAndSharpenTex,coord+vec2(blurRadius,-blurRadius))
    +texture(blurAndSharpenTex,coord+vec2(blurRadius,0.0));
	colorBlur*=.125;
	colorBlur=mix(originalColor,colorBlur,blurAmount);

	//sharpen
    float color_sharpen_bright=
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(sharpenRadius,0)).rgb).z+
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(-sharpenRadius,0)).rgb).z+
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(0,sharpenRadius)).rgb).z+
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(0,-sharpenRadius)).rgb).z+
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(sharpenRadius,sharpenRadius)).rgb).z+
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(-sharpenRadius,sharpenRadius)).rgb).z+
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(sharpenRadius,-sharpenRadius)).rgb).z+
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(-sharpenRadius,-sharpenRadius)).rgb).z;
    color_sharpen_bright=color_sharpen_bright*.125;
    vec3 colorBlurHsb=rgb2hsb(colorBlur.rgb);
    colorBlurHsb.z-=(sharpenAmount)*color_sharpen_bright;
    if(sharpenAmount>0){
        colorBlurHsb.z*=(1.0+sharpenAmount+sharpenBoost);
    }
    return vec4(hsb2rgb(colorBlurHsb),1.0);
}

//general signal utilities
float wrap(float inColor){
	if(inColor<0.0){inColor=1.0-abs(inColor);}
	if(inColor>1.0){inColor=fract(inColor);}
	return inColor;
}

float foldover(float inColor){
	if(inColor<0.0){inColor=abs(inColor);}
	if(inColor>1.0){inColor=1.0-(fract(inColor));}
	if(inColor<0.0){inColor=abs(inColor);}
	return inColor;
}

float mirror(float a){
	if(a>0){return a;}
	if(a<0){return -(1+a);}
}

//MIX
//fg is foreground color, bg is background
//mixmodes 0=lerp, 1=add/subtrac, 2=mult, 3=dodge?
//mixOverflowModes 0-clamp,1 wrap,2 fold?;
//notes: do we want to try anything different for subtractive?
vec4 mixnKeyVideo(vec4 fg, vec4 bg, float amount, int selectMixMode, float keyThreshold,
float keySoft,vec3 keyValue,int keyOrder,int mixOverflow,vec4 mask,int keyMaskSwitch){
	if(keyOrder==1){
		vec4 dummy=fg;
		fg=bg;
		bg=dummy;
	}
	vec4 outColor=vec4(0.0,0.0,0.0,1.0);
	//lerp
	if(selectMixMode==0){outColor=mix(fg, bg, amount);}
	//addsubtrack
	if(selectMixMode==1){outColor.rgb=fg.rgb+amount*bg.rgb;}
	//difference
	if(selectMixMode==2){outColor.rgb=abs(fg.rgb-amount*bg.rgb);}
	//mult
	if(selectMixMode==3){outColor.rgb=mix(fg.rgb,fg.rgb*bg.rgb,amount);}
	//dodge
	if(selectMixMode==4){outColor.rgb=mix(fg.rgb,fg.rgb/(1.00001-bg.rgb),amount);}
	if(mixOverflow==0){outColor.rgb=clamp(outColor.rgb,0.0,1.0);}
	if(mixOverflow==1){
		outColor.r=wrap(outColor.r);
		outColor.g=wrap(outColor.g);
		outColor.b=wrap(outColor.b);
	}
	if(mixOverflow==2){
		outColor.r=foldover(outColor.r);
		outColor.g=foldover(outColor.g);
		outColor.b=foldover(outColor.b);
	}
	float chromaDistance=distance(keyValue,fg.rgb);
	float lower=chromaDistance-keyThreshold;
	if( chromaDistance < keyThreshold ){outColor=mix(bg,outColor,keySoft*abs(1.0-(chromaDistance-keyThreshold)));}
	//not active yet
	if(keyMaskSwitch==1){outColor=mix(outColor,bg,mask.g);}
	return outColor;
}

float solarize(float inBright){
	if(inBright>.5){inBright=1.0-inBright;}
	return inBright;
}
vec2 new_rotate(vec2 inCoords, vec2 inDim, float theta, int mode){
	vec2 rotatedCoords=vec2(0);
	if(mode == 0){
		inCoords=inCoords-.5*inDim;
		rotatedCoords.x = inCoords.x*cos(theta)-inCoords.y*sin(theta);
		rotatedCoords.y = inCoords.x*sin(theta)+inCoords.y*cos(theta);
		rotatedCoords+=.5*inDim;
	}
	if(mode == 1){
		vec2 center_coord=vec2((inCoords.x-.5*inDim.x)/inDim.x,(inCoords.y-.5*inDim.y)/inDim.y);
		rotatedCoords.x=center_coord.x*cos(theta)-center_coord.y*sin(theta);
		rotatedCoords.y=center_coord.x*sin(theta)+center_coord.y*cos(theta);
		rotatedCoords.x=inDim.x*rotatedCoords.x+inDim.x*.5;
		rotatedCoords.y=inDim.y*rotatedCoords.y+inDim.y*.5;
	}
	return rotatedCoords;
}

vec2 new_kaleidoscope(vec2 inCoord, vec2 inDim, float segment, float slice){
	if(segment>0.0){
		inCoord=new_rotate(inCoord,inDim,slice,0);
		inCoord = inCoord/inDim;
		inCoord=2.0*inCoord-1.0;
		float radius=sqrt( dot(inCoord,inCoord) );
		float angle=atan(inCoord.y,inCoord.x);
		float segmentAngle=TWO_PI/segment;
		angle-=segmentAngle*floor(angle/segmentAngle);
		angle=min(angle,segmentAngle-angle);
		inCoord=radius*vec2(cos(angle),sin(angle));
		inCoord=.5*(inCoord+1.0);
		inCoord*=inDim;
		inCoord=new_rotate(inCoord, inDim, -slice,1);
	}
	return inCoord;
}

vec2 new_wrapCoords(vec2 inCoord, vec2 inDim){
    inCoord=mod(inCoord,inDim);
    return inCoord;
}

vec2 new_mirrorCoords(vec2 inCoord, vec2 inDim){
	float widthLess=inDim.x-1.0;
	float heightLess=inDim.y-1.0;
    inCoord.x=(widthLess)-mirror(mod(inCoord.x,2.0*widthLess)-widthLess);
    inCoord.y=(heightLess)-mirror(mod(inCoord.y,2.0*heightLess)-heightLess);
    return inCoord;
}

vec2 new_shear(vec2 inCoord, vec2 inDim, vec4 shearMatrix){
	inCoord-=.5*inDim;
	inCoord.x=shearMatrix.x*inCoord.x+shearMatrix.y*inCoord.y;
	inCoord.y=shearMatrix.z*inCoord.x+shearMatrix.w*inCoord.y;
	inCoord+=.5*inDim;
	return inCoord;
}
void main()
{
	vec2 block2InputCoords=texCoordVarying;

	block2InputCoords+=block2InputCrib;
	block2InputCoords*=block2InputScaler;
	if(block2InputHFlip==1){block2InputCoords.x=block2InputDim.x-block2InputCoords.x;}
	if(block2InputVFlip==1){block2InputCoords.y=block2InputDim.y-block2InputCoords.y;}
	if(block2InputHMirror==1){if(block2InputCoords.x>.5*block2InputDim.x){block2InputCoords.x=abs(block2InputDim.x-block2InputCoords.x);}}
	if(block2InputVMirror==1){if(block2InputCoords.y>.5*block2InputDim.y){block2InputCoords.y=abs(block2InputDim.y-block2InputCoords.y);}}
	block2InputCoords=new_kaleidoscope(block2InputCoords,block2InputDim,block2InputKaleidoscopeAmount,block2InputKaleidoscopeSlice);
	block2InputCoords+=block2InputXYDisplace;	
	block2InputCoords-=.5*block2InputDim;
	block2InputCoords=block2InputCoords*(block2InputZDisplace);
	block2InputCoords+=.5*block2InputDim;
	block2InputCoords=new_rotate(block2InputCoords, block2InputDim, block2InputRotate,0);
	if(block2InputGeoOverflow==1){block2InputCoords=new_wrapCoords(block2InputCoords,block2InputDim);}
	if(block2InputGeoOverflow==2){block2InputCoords=new_mirrorCoords(block2InputCoords,block2InputDim);}
	vec4 block2InputColor=blurAndSharpen(block2InputTex,block2InputCoords,block2InputSharpenAmount,block2InputSharpenRadius,
		block2InputFiltersBoost,block2InputBlurRadius,block2InputBlurAmount);
	if(block2InputCoords.x>block2InputDim.x || block2InputCoords.y> block2InputDim.y || block2InputCoords.x<0.0 || block2InputCoords.y<0.0){
			block2InputColor=vec4(0.0);
		}

	vec3 block2InputColorHSB=rgb2hsb(block2InputColor.rgb);
	block2InputColorHSB=pow(block2InputColorHSB,block2InputHSBAttenuate);	
	if(block2InputHueInvert==1){block2InputColorHSB.x=1.0-block2InputColorHSB.x;}
	if(block2InputSaturationInvert==1){block2InputColorHSB.y=1.0-block2InputColorHSB.y;}
	if(block2InputBrightInvert==1){block2InputColorHSB.z=1.0-block2InputColorHSB.z;}
	block2InputColorHSB.x=fract(block2InputColorHSB.x);
	if(block2InputSolarize==1){block2InputColorHSB.z=solarize(block2InputColorHSB.z);}
	if(block2InputPosterizeSwitch==1){block2InputColorHSB=colorQuantize(block2InputColorHSB,block2InputPosterize,block2InputPosterizeInvert);}
	
	block2InputColor.rgb=hsb2rgb(block2InputColorHSB);
	if(block2InputRGBInvert==1){block2InputColor.rgb=1.0-block2InputColor.rgb;}
	
	
	
	//fb2
	vec2 fb2Coords=texCoordVarying;
	vec2 center=.5*processingDim;
	if(fb2HFlip==1){fb2Coords.x=processingDim.x-fb2Coords.x;}
	if(fb2VFlip==1){fb2Coords.y=processingDim.y-fb2Coords.y;}
	if(fb2HMirror==1){if(fb2Coords.x>.5*processingDim.x){fb2Coords.x=abs(processingDim.x-fb2Coords.x);}}
    if(fb2VMirror==1){if(fb2Coords.y>.5*processingDim.y){fb2Coords.y=abs(processingDim.y-fb2Coords.y);}}
	fb2Coords=new_kaleidoscope(fb2Coords,processingDim,fb2KaleidoscopeAmount,fb2KaleidoscopeSlice);
	fb2Coords+=fb2XYDisplace;
	fb2Coords-=center;
	fb2Coords*=fb2ZDisplace;
	fb2Coords+=center;
	fb2Coords=new_rotate(fb2Coords,processingDim,fb2Rotate,fb2RotateMode);
	fb2Coords=new_shear(fb2Coords,processingDim,fb2ShearMatrix);
	if(fb2GeoOverflow==1){fb2Coords=new_wrapCoords(fb2Coords,processingDim);}
	if(fb2GeoOverflow==2){fb2Coords=new_mirrorCoords(fb2Coords,processingDim);}
			
	vec4 fb2Color=blurAndSharpen(tex0,fb2Coords,fb2SharpenAmount,fb2SharpenRadius,
		fb2FiltersBoost,fb2BlurRadius,fb2BlurAmount);
	if(fb2GeoOverflow==0){
		if(fb2Coords.x>processingDim.x || fb2Coords.y> processingDim.y || fb2Coords.x<0.0 || fb2Coords.y<0.0){
			fb2Color=vec4(0.0);
		}
	}
	//fb2 color biz
	vec3 fb2ColorHSB=rgb2hsb(fb2Color.rgb);
	fb2ColorHSB.x=hueShaper(fb2ColorHSB.x,fb2HueShaper);
	fb2ColorHSB+=fb2HSBOffset;
	fb2ColorHSB*=fb2HSBAttenuate;
	fb2ColorHSB=pow(fb2ColorHSB,fb2HSBPowmap);	
	if(fb2PosterizeSwitch==1){fb2ColorHSB=colorQuantize(fb2ColorHSB,fb2Posterize,fb2PosterizeInvert);}
	if(fb2HueInvert==1){fb2ColorHSB.x=1.0-fb2ColorHSB.x;}
	if(fb2SaturationInvert==1){fb2ColorHSB.y=1.0-fb2ColorHSB.y;}
	if(fb2BrightInvert==1){fb2ColorHSB.z=1.0-fb2ColorHSB.z;}
	fb2ColorHSB.x=fract(fb2ColorHSB.x);
	fb2ColorHSB.y=clamp(fb2ColorHSB.y,0.0,1.0);
	fb2ColorHSB.z=clamp(fb2ColorHSB.z,0.0,1.0);
	
	fb2Color.rgb=hsb2rgb(fb2ColorHSB);
	
		
	vec4 outColor=mixnKeyVideo(block2InputColor,fb2Color,fb2MixAmount,fb2MixType,fb2KeyThreshold,fb2KeySoft
					,fb2KeyValue,fb2KeyOrder,fb2MixOverflow,vec4(0.0,0.0,0.0,0.0),0);


	//temporal filter
	vec4 temporalFilter1Color=texture(fb2TemporalFilter,texCoordVarying);
	vec3 temporalFilter1ColorHSB=rgb2hsb(temporalFilter1Color.rgb);
	vec3 temporalFilter2ColorHSB=temporalFilter1ColorHSB;
	
	//should off board this step out of the shader
	//2 variables, tempFilResSat and tempFilResBright
	temporalFilter1ColorHSB.y=clamp((temporalFilter1ColorHSB.y*(1.0+fb2TemporalFilter1Resonance*.25)),0.0,1.0);
	temporalFilter1ColorHSB.z=clamp((temporalFilter1ColorHSB.z*(1.0+fb2TemporalFilter1Resonance*.5)),0.0,1.0);
	
	temporalFilter1Color.rgb=hsb2rgb(temporalFilter1ColorHSB);
	outColor=clamp(mix(outColor,temporalFilter1Color,fb2TemporalFilter1Amount),0.0,1.0);
	
	temporalFilter2ColorHSB.y=clamp((temporalFilter2ColorHSB.y*(1.0+fb2TemporalFilter2Resonance*.25)),0.0,1.0);
	temporalFilter2ColorHSB.z=clamp((temporalFilter2ColorHSB.z*(1.0+fb2TemporalFilter2Resonance*.5)),0.0,1.0);
	
	vec4 temporalFilter2Color=vec4(hsb2rgb(temporalFilter2ColorHSB),1.0);
	outColor=clamp(mix(outColor,temporalFilter2Color,fb2TemporalFilter2Amount),0.0,1.0);

	outColor.a=1.0;				
	
	outputColor=outColor;
}
