<?php
# ------------------------------------------
# ADD SCRIPTS
# ------------------------------------------
function theming_scripts() {
// CSS
	wp_enqueue_style( 'stylesheet', get_stylesheet_uri() );
//	fonts
	wp_enqueue_style( 'beth-ellen-font', 'https://fonts.googleapis.com/css2?family=Beth+Ellen&display=swap', false );
	wp_enqueue_style( 'oranienbaum-font', 'https://fonts.googleapis.com/css2?family=Oranienbaum&display=swap', false );
// JS
	wp_enqueue_script( 'custom-js', get_template_directory_uri() . '/js/custom.js', array(), '', true );
}
add_action( 'wp_enqueue_scripts', 'theming_scripts' );

# remove smilies/emoticon horridness
function cb_remove_smileys($bool) {
  return false;
}
add_filter('option_use_smilies','cb_remove_smileys',99,1);

# ------------------------------------------
# REGISTER SITE MENUS
# ------------------------------------------
if (function_exists( 'add_theme_support' )) {
	register_nav_menus(
	    array(
	        'sitenav' => __( 'Site nav' ),
	        'footnav' => __( 'Footer nav' )
	    )
	);
}

# ------------------------------------------
# REGISTER SIDEBARS
# ------------------------------------------
function create_sidebar( $name, $id, $description, $class ) {
    register_sidebar(array(
        'name' => __( $name ),
        'id' => $id,
        'description' => __( $description ),
        'before_widget' => '<div id="%1$s" class="'. $class .' %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget--title">',
        'after_title' => '</h3>'
    ));
}

create_sidebar( 'Sidebar', 'sidebar', 'Main site sidebar', 'site-widget' );

# ------------------------------------------
# MOBILE MENU TOGGLE
# ------------------------------------------
function add_mobile_menu_script() {
    ?>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const menuToggle = document.querySelector('.menu-toggle');
        const siteNav = document.querySelector('.sitenav');
        
        if (menuToggle && siteNav) {
            menuToggle.addEventListener('click', function() {
                siteNav.classList.toggle('active');
            });
        }
    });
    </script>
    <?php
}
add_action('wp_footer', 'add_mobile_menu_script');