OF_GLSL_SHADER_HEADER

const float PI=3.1415926535;
const float TWO_PI=6.2831855;

//new 1-25
//stuff we need for the resizing functions
uniform vec2 processingDim;

uniform vec2 ch1Dim;
uniform float ch1Scaler;
uniform vec2 ch1Crib;

uniform vec2 ch2Dim;
uniform float ch2Scaler;
uniform vec2 ch2Crib;

//new 10-24
uniform int fb1KeyOutlineSwitch;
uniform float fb1KeyOutlineThick;
uniform vec4 fb1KeyOutlineColor;

uniform sampler2DRect ch1Tex;
uniform sampler2DRect ch2Tex;
uniform sampler2DRect tex0; //fb1
uniform sampler2DRect fb1TemporalFilter;

uniform vec2 ch1XYDisplace;
uniform float ch1ZDisplace;
uniform float ch1Rotate;
uniform vec3 ch1HSBAttenuate;
uniform float ch1Posterize;
uniform float ch1PosterizeInvert;
uniform int ch1PosterizeSwitch;
uniform float ch1KaleidoscopeAmount;
uniform float ch1KaleidoscopeSlice;
uniform float ch1BlurAmount;
uniform float ch1BlurRadius;
uniform float ch1SharpenAmount;
uniform float ch1SharpenRadius;
uniform float ch1FiltersBoost;	

uniform int ch1HMirror;
uniform int ch1VMirror;
uniform int ch1HFlip;
uniform int ch1VFlip;
uniform int ch1HueInvert;
uniform int ch1SaturationInvert;
uniform int ch1BrightInvert;
uniform int ch1RGBInvert;
uniform int ch1GeoOverflow;
uniform int ch1Solarize;

uniform float ch2MixAmount;
uniform vec3 ch2KeyValue;
uniform float ch2KeyThreshold;
uniform float ch2KeySoft;	
uniform int ch2MixType;
uniform int ch2MixOverflow;
uniform int ch2KeyOrder;

uniform vec2 ch2XYDisplace;
uniform float ch2ZDisplace;
uniform float ch2Rotate;
uniform vec3 ch2HSBAttenuate;
uniform float ch2Posterize;
uniform float ch2PosterizeInvert;
uniform int ch2PosterizeSwitch;
uniform float ch2KaleidoscopeAmount;
uniform float ch2KaleidoscopeSlice;
uniform float ch2BlurAmount;
uniform float ch2BlurRadius;
uniform float ch2SharpenAmount;
uniform float ch2SharpenRadius;
uniform float ch2FiltersBoost;	

uniform int ch2HMirror;
uniform int ch2VMirror;
uniform int ch2HFlip;
uniform int ch2VFlip;
uniform int ch2HueInvert;
uniform int ch2SaturationInvert;
uniform int ch2BrightInvert;
uniform int ch2RGBInvert;
uniform int ch2GeoOverflow;
uniform int ch2Solarize;

uniform float fb1MixAmount;
uniform vec3 fb1KeyValue;
uniform float fb1KeyThreshold;
uniform float fb1KeySoft;	
uniform int fb1MixType;
uniform int fb1MixOverflow;
uniform int fb1KeyOrder;

uniform vec2 fb1XYDisplace;
uniform float fb1ZDisplace;
uniform float fb1Rotate;
uniform vec4 fb1ShearMatrix;
uniform float fb1KaleidoscopeAmount;
uniform float fb1KaleidoscopeSlice;
uniform int fb1HMirror;
uniform int fb1VMirror;
uniform int fb1HFlip;
uniform int fb1VFlip;
uniform int	fb1RotateMode;
uniform	int fb1GeoOverflow;

uniform vec3 fb1HSBOffset;
uniform vec3 fb1HSBAttenuate;
uniform vec3 fb1HSBPowmap;
uniform float fb1HueShaper;
	
uniform float fb1Posterize;
uniform float fb1PosterizeInvert;
uniform int fb1PosterizeSwitch;
uniform int fb1HueInvert;
uniform int fb1SaturationInvert;
uniform int fb1BrightInvert;

//fb1 filters 
uniform	float fb1BlurAmount;
uniform	float fb1BlurRadius;
uniform	float fb1SharpenAmount;
uniform	float fb1SharpenRadius;
uniform	float fb1TemporalFilter1Amount;
uniform	float fb1TemporalFilter1Resonance;
uniform	float fb1TemporalFilter2Amount;
uniform	float fb1TemporalFilter2Resonance;
uniform float fb1FiltersBoost;	

in vec2 texCoordVarying;

out vec4 outputColor;

//color space conversions
vec3 rgb2hsb(vec3 c)
{
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsb2rgb(vec3 c)
{
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

float hueShaper(float inHue,float shaper){
	inHue=fract(abs(inHue+shaper*sin(inHue*0.3184713) ));
	return inHue;
}

vec4 blurAndSharpen(sampler2DRect blurAndSharpenTex,vec2 coord, float sharpenAmount, float sharpenRadius, float sharpenBoost,float blurRadius,float blurAmount){
	vec4 originalColor=texture(blurAndSharpenTex,coord);
	//blur
	vec4 colorBlur=texture(blurAndSharpenTex,coord+vec2(blurRadius,blurRadius))
    + texture(blurAndSharpenTex,coord+vec2(0,blurRadius))
    + texture(blurAndSharpenTex,coord+vec2(-blurRadius,blurRadius))
    +texture(blurAndSharpenTex,coord+vec2(-blurRadius,0.0))
    +texture(blurAndSharpenTex,coord+vec2(-blurRadius,-blurRadius))
    +texture(blurAndSharpenTex,coord+vec2(0.0,-blurRadius))
    +texture(blurAndSharpenTex,coord+vec2(blurRadius,-blurRadius))
    +texture(blurAndSharpenTex,coord+vec2(blurRadius,0.0));
	colorBlur*=.125;
	colorBlur=mix(originalColor,colorBlur,blurAmount);

	//sharpen
    float color_sharpen_bright=
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(sharpenRadius,0)).rgb).z+
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(-sharpenRadius,0)).rgb).z+
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(0,sharpenRadius)).rgb).z+
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(0,-sharpenRadius)).rgb).z+
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(sharpenRadius,sharpenRadius)).rgb).z+
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(-sharpenRadius,sharpenRadius)).rgb).z+
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(sharpenRadius,-sharpenRadius)).rgb).z+
    rgb2hsb(texture(blurAndSharpenTex,coord+vec2(-sharpenRadius,-sharpenRadius)).rgb).z;
    color_sharpen_bright=color_sharpen_bright*.125;
    vec3 colorBlurHsb=rgb2hsb(colorBlur.rgb);
    colorBlurHsb.z-=(sharpenAmount)*color_sharpen_bright;
    if(sharpenAmount>0){
        colorBlurHsb.z*=(1.0+sharpenAmount+sharpenBoost);
    }
    return vec4(hsb2rgb(colorBlurHsb),1.0);
}

//general signal utilities
float wrap(float inColor){
	if(inColor<0.0){inColor=1.0-abs(inColor);}
	if(inColor>1.0){inColor=fract(inColor);}
	return inColor;
}

float foldover(float inColor){
	if(inColor<0.0){inColor=abs(inColor);}
	if(inColor>1.0){inColor=1.0-(fract(inColor));}
	if(inColor<0.0){inColor=abs(inColor);}
	return inColor;
}

float mirror(float a){
	if(a>0){return a;}
	if(a<0){return -(1+a);}
}

//MIX
//fg is foreground color, bg is background
//mixmodes 0=lerp, 1=add/subtrac, 2=mult, 3=dodge?
//mixOverflowModes 0-clamp,1 wrap,2 fold?;
//notes: do we want to try anything different for subtractive?
vec4 mixnKeyVideo(vec4 fg, vec4 bg, float amount, int selectMixMode, float keyThreshold,
float keySoft,vec3 keyValue,int keyOrder,int mixOverflow,vec4 mask,int keyMaskSwitch){
	if(keyOrder==1){
		vec4 dummy=fg;
		fg=bg;
		bg=dummy;
	}
	vec4 outColor=vec4(0.0,0.0,0.0,1.0);
	//lerp
	if(selectMixMode==0){outColor=mix(fg, bg, amount);}
	//addsubtrack
	if(selectMixMode==1){outColor.rgb=fg.rgb+amount*bg.rgb;}
	//difference
	if(selectMixMode==2){outColor.rgb=abs(fg.rgb-amount*bg.rgb);}
	//mult
	if(selectMixMode==3){outColor.rgb=mix(fg.rgb,fg.rgb*bg.rgb,amount);}
	//dodge
	if(selectMixMode==4){outColor.rgb=mix(fg.rgb,fg.rgb/(1.00001-bg.rgb),amount);}
	if(mixOverflow==0){outColor.rgb=clamp(outColor.rgb,0.0,1.0);}
	if(mixOverflow==1){
		outColor.r=wrap(outColor.r);
		outColor.g=wrap(outColor.g);
		outColor.b=wrap(outColor.b);
	}
	if(mixOverflow==2){
		outColor.r=foldover(outColor.r);
		outColor.g=foldover(outColor.g);
		outColor.b=foldover(outColor.b);
	}
	float chromaDistance=distance(keyValue,fg.rgb);
	float lower=chromaDistance-keyThreshold;
	if( chromaDistance < keyThreshold ){outColor=mix(bg,outColor,keySoft*abs(1.0-(chromaDistance-keyThreshold)));}
	//not active yet
	if(keyMaskSwitch==1){outColor=mix(outColor,bg,mask.g);}
	return outColor;
}


vec4 mixnKeyVideoNew(vec4 fg, vec4 bg, float amount, int selectMixMode, float keyThreshold,
float keySoft,vec3 keyValue,int keyOrder,int mixOverflow,vec4 mask,int keyMaskSwitch,
int keyOutlineSwitch, float keyOutlineThick, vec4 keyOutlineColor){
	if(keyOrder==1){
		vec4 dummy=fg;
		fg=bg;
		bg=dummy;
	}
	vec4 outColor=vec4(0.0,0.0,0.0,1.0);
	//lerp
	if(selectMixMode==0){outColor=mix(fg, bg, amount);}
	//addsubtrack
	if(selectMixMode==1){outColor.rgb=fg.rgb+amount*bg.rgb;}
	//difference
	if(selectMixMode==2){outColor.rgb=abs(fg.rgb-amount*bg.rgb);}
	//mult
	if(selectMixMode==3){outColor.rgb=mix(fg.rgb,fg.rgb*bg.rgb,amount);}
	//dodge
	if(selectMixMode==4){outColor.rgb=mix(fg.rgb,fg.rgb/(1.00001-bg.rgb),amount);	}
	if(mixOverflow==0){outColor.rgb=clamp(outColor.rgb,0.0,1.0);}
	if(mixOverflow==1){
		outColor.r=wrap(outColor.r);
		outColor.g=wrap(outColor.g);
		outColor.b=wrap(outColor.b);
	}
	if(mixOverflow==2){
		outColor.r=foldover(outColor.r);
		outColor.g=foldover(outColor.g);
		outColor.b=foldover(outColor.b);
	}
	float chromaDistance=distance(keyValue,fg.rgb);
	float lower=chromaDistance-keyThreshold;
	if( chromaDistance < keyThreshold ){
		outColor=mix(bg,outColor,keySoft*abs(1.0-(chromaDistance-keyThreshold)));
	 }
	 //add an outline to the key value
	 //lets add the ability to thicken it as well
	 //this kinda looks like shit but maybe also with a blur?
	 if (keyOutlineSwitch == 1){
		 //float outlineThreshold=.01;
		 if( abs(chromaDistance-keyThreshold)<= keyOutlineThick ){
			outColor=keyOutlineColor;
		 }
	 }
	//so masking will be a different mode than luma or chromakeying so
	//will need to have a different switch for that integrated in here lol
	//taking for granted that the mask is in greyscale so any rgb value can be
	//used as test
	//starting off with 1 (white) returns fg and 0 (black) returns bg
	if(keyMaskSwitch==1){outColor=mix(outColor,bg,mask.g);}
	
	return outColor;
}

float solarize(float inBright){
	if(inBright>.5){inBright=1.0-inBright;}
	return inBright;
}

vec2 new_rotate(vec2 inCoords, vec2 inDim, float theta, int mode){
	vec2 rotatedCoords=vec2(0);
	if(mode == 0){
		inCoords=inCoords-.5*inDim;
		rotatedCoords.x = inCoords.x*cos(theta)-inCoords.y*sin(theta);
		rotatedCoords.y = inCoords.x*sin(theta)+inCoords.y*cos(theta);
		rotatedCoords+=.5*inDim;
	}
	if(mode == 1){
		vec2 center_coord=vec2((inCoords.x-.5*inDim.x)/inDim.x,(inCoords.y-.5*inDim.y)/inDim.y);
		rotatedCoords.x=center_coord.x*cos(theta)-center_coord.y*sin(theta);
		rotatedCoords.y=center_coord.x*sin(theta)+center_coord.y*cos(theta);
		rotatedCoords.x=inDim.x*rotatedCoords.x+inDim.x*.5;
		rotatedCoords.y=inDim.y*rotatedCoords.y+inDim.y*.5;
	}
	return rotatedCoords;
}

vec2 new_kaleidoscope(vec2 inCoord, vec2 inDim, float segment, float slice){
	if(segment>0.0){
		inCoord=new_rotate(inCoord,inDim,slice,0);
		inCoord = inCoord/inDim;
		inCoord=2.0*inCoord-1.0;
		float radius=sqrt( dot(inCoord,inCoord) );
		float angle=atan(inCoord.y,inCoord.x);
		float segmentAngle=TWO_PI/segment;
		angle-=segmentAngle*floor(angle/segmentAngle);
		angle=min(angle,segmentAngle-angle);
		inCoord=radius*vec2(cos(angle),sin(angle));
		inCoord=.5*(inCoord+1.0);
		inCoord*=inDim;
		inCoord=new_rotate(inCoord, inDim, -slice,1);
	}
	return inCoord;
}

vec2 new_wrapCoords(vec2 inCoord, vec2 inDim){
    inCoord=mod(inCoord,inDim);
    return inCoord;
}

vec2 new_mirrorCoords(vec2 inCoord, vec2 inDim){
	float widthLess=inDim.x-1.0;
	float heightLess=inDim.y-1.0;
    inCoord.x=(widthLess)-mirror(mod(inCoord.x,2.0*widthLess)-widthLess);
    inCoord.y=(heightLess)-mirror(mod(inCoord.y,2.0*heightLess)-heightLess);
    return inCoord;
}

vec2 new_shear(vec2 inCoord, vec2 inDim, vec4 shearMatrix){
	inCoord-=.5*inDim;
	inCoord.x=shearMatrix.x*inCoord.x+shearMatrix.y*inCoord.y;
	inCoord.y=shearMatrix.z*inCoord.x+shearMatrix.w*inCoord.y;
	inCoord+=.5*inDim;
	return inCoord;
}

vec3 colorQuantize(vec3 inColor, float amount, float amountInvert){
	inColor=ceil(inColor*amount)*amountInvert;
	return inColor;
}

void main(){
	//CHANNEL 1
	vec2 ch1Coords=texCoordVarying;

	ch1Coords+=ch1Crib;
	ch1Coords*=ch1Scaler;
	if(ch1HFlip==1){ch1Coords.x=ch1Dim.x-ch1Coords.x;}
	if(ch1VFlip==1){ch1Coords.y=ch1Dim.y-ch1Coords.y;}
	if(ch1HMirror==1){if(ch1Coords.x>.5*ch1Dim.x){ch1Coords.x=abs(ch1Dim.x-ch1Coords.x);}}
	if(ch1VMirror==1){if(ch1Coords.y>.5*ch1Dim.y){ch1Coords.y=abs(ch1Dim.y-ch1Coords.y);}}
	ch1Coords=new_kaleidoscope(ch1Coords,ch1Dim,ch1KaleidoscopeAmount,ch1KaleidoscopeSlice);
	ch1Coords+=ch1XYDisplace;	
	ch1Coords-=.5*ch1Dim;
	ch1Coords=ch1Coords*(ch1ZDisplace);
	ch1Coords+=.5*ch1Dim;
	ch1Coords=new_rotate(ch1Coords, ch1Dim, ch1Rotate,0);
	if(ch1GeoOverflow==1){ch1Coords=new_wrapCoords(ch1Coords,ch1Dim);}
	if(ch1GeoOverflow==2){ch1Coords=new_mirrorCoords(ch1Coords,ch1Dim);}
	vec4 ch1Color=blurAndSharpen(ch1Tex,ch1Coords,ch1SharpenAmount,ch1SharpenRadius,
		ch1FiltersBoost,ch1BlurRadius,ch1BlurAmount);
	if(ch1Coords.x>ch1Dim.x || ch1Coords.y> ch1Dim.y || ch1Coords.x<0.0 || ch1Coords.y<0.0){
			ch1Color=vec4(0.0);
		}

	vec3 ch1ColorHSB=rgb2hsb(ch1Color.rgb);
	ch1ColorHSB=pow(ch1ColorHSB,ch1HSBAttenuate);	
	if(ch1HueInvert==1){ch1ColorHSB.x=1.0-ch1ColorHSB.x;}
	if(ch1SaturationInvert==1){ch1ColorHSB.y=1.0-ch1ColorHSB.y;}
	if(ch1BrightInvert==1){ch1ColorHSB.z=1.0-ch1ColorHSB.z;}
	ch1ColorHSB.x=fract(ch1ColorHSB.x);
	if(ch1Solarize==1){ch1ColorHSB.z=solarize(ch1ColorHSB.z);}
	if(ch1PosterizeSwitch==1){ch1ColorHSB=colorQuantize(ch1ColorHSB,ch1Posterize,ch1PosterizeInvert);}
	
	ch1Color.rgb=hsb2rgb(ch1ColorHSB);
	if(ch1RGBInvert==1){ch1Color.rgb=1.0-ch1Color.rgb;}

	//CHANNEL 2

	vec2 ch2Coords=texCoordVarying;

	ch2Coords+=ch2Crib;
	ch2Coords*=ch2Scaler;
	if(ch2HFlip==1){ch2Coords.x=ch2Dim.x-ch2Coords.x;}
	if(ch2VFlip==1){ch2Coords.y=ch2Dim.y-ch2Coords.y;}
	if(ch2HMirror==1){if(ch2Coords.x>.5*ch2Dim.x){ch2Coords.x=abs(ch2Dim.x-ch2Coords.x);}}
	if(ch2VMirror==1){if(ch2Coords.y>.5*ch2Dim.y){ch2Coords.y=abs(ch2Dim.y-ch2Coords.y);}}
	ch2Coords=new_kaleidoscope(ch2Coords,ch2Dim,ch2KaleidoscopeAmount,ch2KaleidoscopeSlice);
	ch2Coords+=ch2XYDisplace;	
	ch2Coords-=.5*ch2Dim;
	ch2Coords=ch2Coords*(ch2ZDisplace);
	ch2Coords+=.5*ch2Dim;
	ch2Coords=new_rotate(ch2Coords, ch2Dim, ch2Rotate,0);
	if(ch2GeoOverflow==1){ch2Coords=new_wrapCoords(ch2Coords,ch2Dim);}
	if(ch2GeoOverflow==2){ch2Coords=new_mirrorCoords(ch2Coords,ch2Dim);}
	vec4 ch2Color=blurAndSharpen(ch2Tex,ch2Coords,ch2SharpenAmount,ch2SharpenRadius,
		ch2FiltersBoost,ch2BlurRadius,ch2BlurAmount);
	if(ch2Coords.x>ch2Dim.x || ch2Coords.y> ch2Dim.y || ch2Coords.x<0.0 || ch2Coords.y<0.0){
			ch2Color=vec4(0.0);
		}

	vec3 ch2ColorHSB=rgb2hsb(ch2Color.rgb);
	ch2ColorHSB=pow(ch2ColorHSB,ch2HSBAttenuate);	
	if(ch2HueInvert==1){ch2ColorHSB.x=1.0-ch2ColorHSB.x;}
	if(ch2SaturationInvert==1){ch2ColorHSB.y=1.0-ch2ColorHSB.y;}
	if(ch2BrightInvert==1){ch2ColorHSB.z=1.0-ch2ColorHSB.z;}
	ch2ColorHSB.x=fract(ch2ColorHSB.x);
	if(ch2Solarize==1){ch2ColorHSB.z=solarize(ch2ColorHSB.z);}
	if(ch2PosterizeSwitch==1){ch2ColorHSB=colorQuantize(ch2ColorHSB,ch2Posterize,ch2PosterizeInvert);}
	
	ch2Color.rgb=hsb2rgb(ch2ColorHSB);
	if(ch2RGBInvert==1){ch2Color.rgb=1.0-ch2Color.rgb;}
	
	//fb1
	vec2 fb1Coords=texCoordVarying;
	vec2 center=.5*processingDim;
	if(fb1HFlip==1){fb1Coords.x=processingDim.x-fb1Coords.x;}
	if(fb1VFlip==1){fb1Coords.y=processingDim.y-fb1Coords.y;}
	if(fb1HMirror==1){if(fb1Coords.x>.5*processingDim.x){fb1Coords.x=abs(processingDim.x-fb1Coords.x);}}
    if(fb1VMirror==1){if(fb1Coords.y>.5*processingDim.y){fb1Coords.y=abs(processingDim.y-fb1Coords.y);}}
	fb1Coords=new_kaleidoscope(fb1Coords,processingDim,fb1KaleidoscopeAmount,fb1KaleidoscopeSlice);
	fb1Coords+=fb1XYDisplace;
	fb1Coords-=center;
	fb1Coords*=fb1ZDisplace;
	fb1Coords+=center;
	fb1Coords=new_rotate(fb1Coords,processingDim,fb1Rotate,fb1RotateMode);
	fb1Coords=new_shear(fb1Coords,processingDim,fb1ShearMatrix);
	if(fb1GeoOverflow==1){fb1Coords=new_wrapCoords(fb1Coords,processingDim);}
	if(fb1GeoOverflow==2){fb1Coords=new_mirrorCoords(fb1Coords,processingDim);}
			
	vec4 fb1Color=blurAndSharpen(tex0,fb1Coords,fb1SharpenAmount,fb1SharpenRadius,
		fb1FiltersBoost,fb1BlurRadius,fb1BlurAmount);
	if(fb1GeoOverflow==0){
		if(fb1Coords.x>processingDim.x || fb1Coords.y> processingDim.y || fb1Coords.x<0.0 || fb1Coords.y<0.0){
			fb1Color=vec4(0.0);
		}
	}
	//fb1 color biz
	vec3 fb1ColorHSB=rgb2hsb(fb1Color.rgb);
	fb1ColorHSB.x=hueShaper(fb1ColorHSB.x,fb1HueShaper);
	fb1ColorHSB+=fb1HSBOffset;
	fb1ColorHSB*=fb1HSBAttenuate;
	fb1ColorHSB=pow(fb1ColorHSB,fb1HSBPowmap);	
	if(fb1PosterizeSwitch==1){fb1ColorHSB=colorQuantize(fb1ColorHSB,fb1Posterize,fb1PosterizeInvert);}
	if(fb1HueInvert==1){fb1ColorHSB.x=1.0-fb1ColorHSB.x;}
	if(fb1SaturationInvert==1){fb1ColorHSB.y=1.0-fb1ColorHSB.y;}
	if(fb1BrightInvert==1){fb1ColorHSB.z=1.0-fb1ColorHSB.z;}
	fb1ColorHSB.x=fract(fb1ColorHSB.x);
	fb1ColorHSB.y=clamp(fb1ColorHSB.y,0.0,1.0);
	fb1ColorHSB.z=clamp(fb1ColorHSB.z,0.0,1.0);
	
	fb1Color.rgb=hsb2rgb(fb1ColorHSB);

	//mix ch1 with ch2
	vec4 outColor=mixnKeyVideo(ch1Color,ch2Color,ch2MixAmount,ch2MixType,ch2KeyThreshold,
		ch2KeySoft,ch2KeyValue,ch2KeyOrder,ch2MixOverflow,vec4(0.0,0.0,0.0,0.0),0);
	//mix ch2 with fb1
	outColor=mixnKeyVideoNew(outColor,fb1Color,fb1MixAmount,fb1MixType,fb1KeyThreshold,
		fb1KeySoft,fb1KeyValue,fb1KeyOrder,fb1MixOverflow,vec4(0.0,0.0,0.0,0.0),0,fb1KeyOutlineSwitch,fb1KeyOutlineThick,fb1KeyOutlineColor);
	
	//temporal filter
	vec4 temporalFilter1Color=texture(fb1TemporalFilter,texCoordVarying);
	vec3 temporalFilter1ColorHSB=rgb2hsb(temporalFilter1Color.rgb);
	vec3 temporalFilter2ColorHSB=temporalFilter1ColorHSB;
	
	//should off board this step out of the shader
	//2 variables, tempFilResSat and tempFilResBright
	temporalFilter1ColorHSB.y=clamp((temporalFilter1ColorHSB.y*(1.0+fb1TemporalFilter1Resonance*.25)),0.0,1.0);
	temporalFilter1ColorHSB.z=clamp((temporalFilter1ColorHSB.z*(1.0+fb1TemporalFilter1Resonance*.5)),0.0,1.0);
	
	temporalFilter1Color.rgb=hsb2rgb(temporalFilter1ColorHSB);
	outColor=clamp(mix(outColor,temporalFilter1Color,fb1TemporalFilter1Amount),0.0,1.0);
	
	temporalFilter2ColorHSB.y=clamp((temporalFilter2ColorHSB.y*(1.0+fb1TemporalFilter2Resonance*.25)),0.0,1.0);
	temporalFilter2ColorHSB.z=clamp((temporalFilter2ColorHSB.z*(1.0+fb1TemporalFilter2Resonance*.5)),0.0,1.0);
	
	vec4 temporalFilter2Color=vec4(hsb2rgb(temporalFilter2ColorHSB),1.0);
	outColor=clamp(mix(outColor,temporalFilter2Color,fb1TemporalFilter2Amount),0.0,1.0);
	
	outputColor=outColor;
}
